/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Iterator;
import liquibase.logging.LogLevel;
import liquibase.logging.LogType;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class CommandLineOutputAppender
extends ConsoleAppender {
    private Mode mode = Mode.STANDARD;

    public CommandLineOutputAppender(ILoggerFactory loggerContext, String target) {
        this.setContext((Context)((LoggerContext)loggerContext));
        this.setTarget(target);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%msg%n");
        encoder.setContext((Context)((LoggerContext)loggerContext));
        encoder.start();
        this.setEncoder((Encoder)encoder);
        this.addFilter(new ModeFilter());
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    protected static void setupLogging(Logger rootLogger, LogLevel defaultLogLevel) {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)rootLogger;
        root.setLevel(Level.toLevel((String)defaultLogLevel.name()));
        ConsoleLogFilter consoleLogFilter = new ConsoleLogFilter();
        Iterator appenderIterator = root.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            Appender next = (Appender)appenderIterator.next();
            if (!(next instanceof ConsoleAppender)) continue;
            ((ConsoleAppender)next).addFilter((Filter)consoleLogFilter);
        }
        for (String target : new String[]{"System.out", "System.err"}) {
            CommandLineOutputAppender appender = new CommandLineOutputAppender(LoggerFactory.getILoggerFactory(), target);
            root.addAppender((Appender)appender);
            appender.start();
        }
    }

    private static class ConsoleLogFilter
    extends AbstractMatcherFilter {
        private boolean outputLogs;

        private ConsoleLogFilter() {
        }

        public FilterReply decide(Object event) {
            if (this.outputLogs) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.DENY;
        }
    }

    public static enum Mode {
        STANDARD,
        PIPE_SQL,
        FULL_LOG;

    }

    protected class ModeFilter
    extends Filter {
        protected ModeFilter() {
        }

        public FilterReply decide(Object event) {
            Marker marker = ((LoggingEvent)event).getMarker();
            LogType logType = LogType.valueOf(marker.getName());
            if (CommandLineOutputAppender.this.mode == Mode.STANDARD) {
                if (logType == LogType.USER_MESSAGE && CommandLineOutputAppender.this.target.equals((Object)ConsoleTarget.SystemOut)) {
                    return FilterReply.ACCEPT;
                }
                return FilterReply.DENY;
            }
            if (CommandLineOutputAppender.this.mode == Mode.PIPE_SQL) {
                if (logType == LogType.USER_MESSAGE && CommandLineOutputAppender.this.target == ConsoleTarget.SystemErr) {
                    return FilterReply.ACCEPT;
                }
                if (logType == LogType.WRITE_SQL && CommandLineOutputAppender.this.target == ConsoleTarget.SystemOut) {
                    return FilterReply.ACCEPT;
                }
                return FilterReply.DENY;
            }
            return FilterReply.DENY;
        }
    }
}

