/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class ItsProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("[^$]*").text("$").expression(",?[^,]+,").groupBegin().expression("[^,]+,").expression("[^,]+,").expression("(..),").number("(d+),").optional().expression("([LH]),").or().expression("([^,]+),").groupEnd().number("(d{15}),").groupBegin().expression("(..),").or().expression("[^,]*,").number("([01]),").optional().groupEnd().number("(dd),?(dd),?(d{2,4}),").number("(dd),?(dd),?(dd),").expression("([01AV]),").optional().number("(d+.d+),([NS]),").number("(d+.d+),([EW]),").groupBegin().number("(d+.?d*),").number("(d+.?d*),").number("(d+),").groupBegin().number("(d+.?d*),").number("d+.?d*,").number("d+.?d*,").expression("[^,]*,").number("([01]),").number("([01]),").number("(d+.?d*),").number("(d+.?d*),").number("([01]),").expression("[CO]?,").expression("(.*),").number("([012]{4}),").number("([01]{2}),").groupBegin().number("d+,").number("(d+.d+),").number("(d+.d+),").groupEnd("?").groupEnd("?").or().number("(-?d+.d+),").number("(d+.d+),").groupEnd().any().compile();

    public ItsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(String status) {
        switch (status) {
            case "WD": 
            case "EA": {
                return "sos";
            }
            case "BL": {
                return "lowBattery";
            }
            case "HB": {
                return "hardBraking";
            }
            case "HA": {
                return "hardAcceleration";
            }
            case "RT": {
                return "hardCornering";
            }
            case "OS": {
                return "overspeed";
            }
            case "TA": {
                return "tampering";
            }
            case "BD": {
                return "powerCut";
            }
            case "BR": {
                return "powerRestored";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        if (channel != null && sentence.startsWith("$,01,")) {
            channel.writeAndFlush((Object)new NetworkMessage("$,1,*", remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, sentence)).matches()) {
            return null;
        }
        String status = parser.next();
        Integer event = parser.nextInt();
        boolean history = "H".equals(parser.next());
        String type = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (type != null && type.equals("EMR")) {
            position.set("alarm", "sos");
        }
        if (event != null) {
            position.set("event", event);
        }
        if (history) {
            position.set("archive", true);
        }
        if (parser.hasNext()) {
            status = parser.next();
        }
        if (status != null) {
            if (status.equals("IN")) {
                position.set("ignition", true);
            } else if (status.equals("IF")) {
                position.set("ignition", false);
            } else {
                position.set("alarm", this.decodeAlarm(status));
            }
        }
        if (parser.hasNext()) {
            position.setValid(parser.nextInt() == 1);
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        if (parser.hasNext()) {
            position.setValid(parser.next().matches("[1A]"));
        }
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        if (parser.hasNext(3)) {
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
            position.setCourse(parser.nextDouble());
            position.set("sat", parser.nextInt());
        }
        if (parser.hasNext(8)) {
            position.setAltitude(parser.nextDouble());
            position.set("ignition", parser.nextInt() > 0);
            position.set("charge", parser.nextInt() > 0);
            position.set("power", parser.nextDouble());
            position.set("battery", parser.nextDouble());
            position.set("emergency", parser.nextInt() > 0);
            String[] cells = parser.next().split(",");
            int mcc = Integer.parseInt(cells[1]);
            int mnc = Integer.parseInt(cells[2]);
            int lac = Integer.parseInt(cells[3], 16);
            int cid = Integer.parseInt(cells[4], 16);
            Network network = new Network(CellTower.from(mcc, mnc, lac, cid, Integer.parseInt(cells[0])));
            if (!cells[5].startsWith("(")) {
                for (int i = 0; i < 4; ++i) {
                    lac = Integer.parseInt(cells[5 + 3 * i + 1], 16);
                    cid = Integer.parseInt(cells[5 + 3 * i + 2], 16);
                    if (lac <= 0 || cid <= 0) continue;
                    network.addCellTower(CellTower.from(mcc, mnc, lac, cid));
                }
            }
            position.setNetwork(network);
            String input = parser.next();
            if (input.charAt(input.length() - 1) == '2') {
                input = input.substring(0, input.length() - 1) + '0';
            }
            position.set("input", Integer.parseInt(input, 2));
            position.set("output", parser.nextBinInt());
        }
        if (parser.hasNext(2)) {
            position.set("adc1", parser.nextDouble());
            position.set("adc2", parser.nextDouble());
        }
        if (parser.hasNext(2)) {
            position.setAltitude(parser.nextDouble());
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        }
        return position;
    }
}

