/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class MictrackProtocolDecoder
extends BaseProtocolDecoder {
    public MictrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Date decodeTime(String data) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.parse(data);
    }

    private String decodeAlarm(int event) {
        switch (event) {
            case 5: {
                return "sos";
            }
            case 8: {
                return "lowBattery";
            }
            case 9: {
                return "geofenceEnter";
            }
            case 10: {
                return "geofenceExit";
            }
            case 12: {
                return "powerOff";
            }
        }
        return null;
    }

    private void decodeLocation(Position position, String data) throws ParseException {
        int index = 0;
        String[] values = data.split("\\+");
        position.set("sat", Integer.parseInt(values[index++]));
        position.setValid(true);
        position.setTime(this.decodeTime(values[index++]));
        position.setLatitude(Double.parseDouble(values[index++]));
        position.setLongitude(Double.parseDouble(values[index++]));
        position.setSpeed(UnitsConverter.knotsFromMps(Double.parseDouble(values[index++])));
        position.setCourse(Integer.parseInt(values[index++]));
        int event = Integer.parseInt(values[index++]);
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        position.set("battery", (double)Integer.parseInt(values[index++]) * 0.001);
    }

    private void decodeCell(Network network, String data) {
        String[] values = data.split(",");
        int length = values.length % 5 == 0 ? 5 : 4;
        for (int i = 0; i < values.length / length; ++i) {
            int mnc = Integer.parseInt(values[i * length]);
            int cid = Integer.parseInt(values[i * length + 1]);
            int lac = Integer.parseInt(values[i * length + 2]);
            int mcc = Integer.parseInt(values[i * length + 3]);
            network.addCellTower(CellTower.from(mcc, mnc, lac, cid));
        }
    }

    private void decodeWifi(Network network, String data) {
        String[] values = data.split(",");
        for (int i = 0; i < values.length / 2; ++i) {
            network.addWifiAccessPoint(WifiAccessPoint.from(values[i * 2], Integer.parseInt(values[i * 2 + 1])));
        }
    }

    private void decodeNetwork(Position position, String data, boolean hasWifi, boolean hasCell) throws ParseException {
        int index = 0;
        String[] values = data.split("\\+");
        this.getLastLocation(position, this.decodeTime(values[index++]));
        Network network = new Network();
        if (hasWifi) {
            this.decodeWifi(network, values[index++]);
        }
        if (hasCell) {
            this.decodeCell(network, values[index++]);
        }
        position.setNetwork(network);
        int event = Integer.parseInt(values[index++]);
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        position.set("battery", (double)Integer.parseInt(values[index++]) * 0.001);
    }

    private void decodeStatus(Position position, String data) throws ParseException {
        int index = 0;
        String[] values = data.split("\\+");
        position.set("sat", Integer.parseInt(values[index++]));
        this.getLastLocation(position, this.decodeTime(values[index++]));
        index += 4;
        int event = Integer.parseInt(values[index++]);
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        position.set("battery", (double)Integer.parseInt(values[index++]) * 0.001);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String[] fragments = ((String)msg).split(";");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, fragments[2]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        switch (fragments[3]) {
            case "R0": {
                this.decodeLocation(position, fragments[4]);
                break;
            }
            case "R1": {
                this.decodeNetwork(position, fragments[4], true, false);
                break;
            }
            case "R2": 
            case "R3": {
                this.decodeNetwork(position, fragments[4], false, true);
                break;
            }
            case "R12": 
            case "R13": {
                this.decodeNetwork(position, fragments[4], true, true);
                break;
            }
            case "RH": {
                this.decodeStatus(position, fragments[4]);
                break;
            }
            default: {
                return null;
            }
        }
        return position;
    }
}

