/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.TimeZone;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class MiniFinderProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    public MiniFinderProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    public String formatValue(String key, Object value) {
        switch (key) {
            case "enable": {
                return (Boolean)value != false ? "1" : "0";
            }
            case "timezone": {
                return String.format("%+03d", TimeZone.getTimeZone((String)value).getRawOffset() / 3600000);
            }
            case "index": {
                switch (((Number)value).intValue()) {
                    case 0: {
                        return "A";
                    }
                    case 1: {
                        return "B";
                    }
                    case 2: {
                        return "C";
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    protected Object encodeCommand(Command command) {
        this.initDevicePassword(command, "123456");
        switch (command.getType()) {
            case "setTimezone": {
                return this.formatCommand(command, "{%s}L{%s}", this, "devicePassword", "timezone");
            }
            case "voiceMonitoring": {
                return this.formatCommand(command, "{%s}P{%s}", this, "devicePassword", "enable");
            }
            case "alarmSpeed": {
                return this.formatCommand(command, "{%s}J1{%s}", "devicePassword", "data");
            }
            case "movementAlarm": {
                return this.formatCommand(command, "{%s}R1{%s}", "devicePassword", "radius");
            }
            case "alarmVibration": {
                return this.formatCommand(command, "{%s}W1,{%s}", "devicePassword", "data");
            }
            case "setAgps": {
                return this.formatCommand(command, "{%s}AGPS{%s}", this, "devicePassword", "enable");
            }
            case "alarmFall": {
                return this.formatCommand(command, "{%s}F{%s}", this, "devicePassword", "enable");
            }
            case "modePowerSaving": {
                return this.formatCommand(command, "{%s}SP{%s}", this, "devicePassword", "enable");
            }
            case "modeDeepSleep": {
                return this.formatCommand(command, "{%s}DS{%s}", this, "devicePassword", "enable");
            }
            case "sosNumber": {
                return this.formatCommand(command, "{%s}{%s}1,{%s}", this, "devicePassword", "index", "phone");
            }
            case "setIndicator": {
                return this.formatCommand(command, "{%s}LED{%s}", "devicePassword", "data");
            }
        }
        return null;
    }
}

