/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.TimeZone;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class Pt502ProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    public Pt502ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    public String formatValue(String key, Object value) {
        if (key.equals("timezone")) {
            return String.valueOf(TimeZone.getTimeZone((String)value).getRawOffset() / 3600000);
        }
        return null;
    }

    @Override
    protected String formatCommand(Command command, String format, String ... keys) {
        return this.formatCommand(command, format, this, keys);
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(command, "{%s}\r\n", "data");
            }
            case "outputControl": {
                return this.formatCommand(command, "#OPC{%s},{%s}\r\n", "index", "data");
            }
            case "setTimezone": {
                return this.formatCommand(command, "#TMZ{%s}\r\n", "timezone");
            }
            case "alarmSpeed": {
                return this.formatCommand(command, "#SPD{%s}\r\n", "data");
            }
            case "requestPhoto": {
                return this.formatCommand(command, "#PHO\r\n", new String[0]);
            }
        }
        return null;
    }
}

