/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class RuptelaProtocolEncoder
extends BaseProtocolEncoder {
    public RuptelaProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(int type, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(1 + content.readableBytes());
        buf.writeByte(100 + type);
        buf.writeBytes(content);
        buf.writeShort(Checksum.crc16(Checksum.CRC16_KERMIT, buf.nioBuffer(2, buf.writerIndex() - 2)));
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        ByteBuf content = Unpooled.buffer();
        switch (command.getType()) {
            case "custom": {
                content.writeBytes(command.getString("data").getBytes(StandardCharsets.US_ASCII));
                return this.encodeContent(8, content);
            }
            case "requestPhoto": {
                content.writeByte(1);
                content.writeByte(0);
                content.writeInt(0);
                content.writeInt(Integer.MAX_VALUE);
                return this.encodeContent(37, content);
            }
            case "configuration": {
                content.writeBytes((command.getString("data") + "\r\n").getBytes(StandardCharsets.US_ASCII));
                return this.encodeContent(2, content);
            }
            case "getVersion": {
                return this.encodeContent(3, content);
            }
            case "firmwareUpdate": {
                content.writeBytes("|FU_STRT*\r\n".getBytes(StandardCharsets.US_ASCII));
                return this.encodeContent(4, content);
            }
            case "outputControl": {
                content.writeInt(command.getInteger("index"));
                content.writeInt(Integer.parseInt(command.getString("data")));
                return this.encodeContent(17, content);
            }
            case "setConnection": {
                String c = command.getString("server") + "," + command.getInteger("port") + ",TCP";
                content.writeBytes(c.getBytes(StandardCharsets.US_ASCII));
                return this.encodeContent(5, content);
            }
            case "setOdometer": {
                content.writeInt(Integer.parseInt(command.getString("data")));
                return this.encodeContent(6, content);
            }
        }
        return null;
    }
}

