/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class SigfoxProtocolDecoder
extends BaseHttpProtocolDecoder {
    public SigfoxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        JsonObject json;
        DeviceSession deviceSession;
        FullHttpRequest request = (FullHttpRequest)msg;
        String content = request.content().toString(StandardCharsets.UTF_8);
        if (!content.startsWith("{")) {
            content = URLDecoder.decode(content.split("=")[0], "UTF-8");
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, (json = Json.createReader((Reader)new StringReader(content)).readObject()).getString("device"))) == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date((long)json.getInt("time") * 1000L));
        String data = json.getString(json.containsKey((Object)"data") ? "data" : "payload");
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(data));
        try {
            short event = buf.readUnsignedByte();
            if (event >> 4 == 0) {
                position.setValid(true);
                position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                position.setCourse(buf.readUnsignedByte() * 2);
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                position.set("battery", (double)buf.readUnsignedByte() * 0.025);
            } else {
                position.set("event", Integer.valueOf(event));
                block14: while (buf.isReadable()) {
                    short type = buf.readUnsignedByte();
                    switch (type) {
                        case 1: {
                            position.setValid(true);
                            position.setLatitude(buf.readMedium());
                            position.setLongitude(buf.readMedium());
                            continue block14;
                        }
                        case 2: {
                            position.setValid(true);
                            position.setLatitude(buf.readFloat());
                            position.setLongitude(buf.readFloat());
                            continue block14;
                        }
                        case 3: {
                            position.set("temp1", (double)buf.readByte() * 0.5);
                            continue block14;
                        }
                        case 4: {
                            position.set("battery", (double)buf.readUnsignedByte() * 0.1);
                            continue block14;
                        }
                        case 5: {
                            position.set("batteryLevel", buf.readUnsignedByte());
                            continue block14;
                        }
                        case 6: {
                            String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                            position.setNetwork(new Network(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), buf.readUnsignedByte())));
                            continue block14;
                        }
                        case 7: {
                            buf.skipBytes(10);
                            continue block14;
                        }
                        case 8: {
                            buf.skipBytes(6);
                            continue block14;
                        }
                        case 9: {
                            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                            continue block14;
                        }
                    }
                    buf.readUnsignedByte();
                }
            }
        }
        finally {
            buf.release();
        }
        if (position.getLatitude() == 0.0 && position.getLongitude() == 0.0) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (json.containsKey((Object)"rssi")) {
            position.set("rssi", json.getJsonNumber("rssi").doubleValue());
        }
        if (json.containsKey((Object)"seqNumber")) {
            position.set("index", json.getInt("seqNumber"));
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }
}

