/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class SuntechProtocolEncoder
extends StringProtocolEncoder {
    public SuntechProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "rebootDevice": {
                return this.formatCommand(command, "SA200CMD;{%s};02;Reboot\r", "uniqueId");
            }
            case "positionSingle": {
                return this.formatCommand(command, "SA200GTR;{%s};02;\r", "uniqueId");
            }
            case "outputControl": {
                if (command.getAttributes().containsKey("data")) {
                    if (command.getAttributes().get("data").equals("1")) {
                        return this.formatCommand(command, "SA200CMD;{%s};02;Enable{%s}\r", "uniqueId", "index");
                    }
                    return this.formatCommand(command, "SA200CMD;{%s};02;Disable{%s}\r", "uniqueId", "index");
                }
            }
            case "engineStop": {
                return this.formatCommand(command, "SA200CMD;{%s};02;Enable1\r", "uniqueId");
            }
            case "engineResume": {
                return this.formatCommand(command, "SA200CMD;{%s};02;Disable1\r", "uniqueId");
            }
            case "alarmArm": {
                return this.formatCommand(command, "SA200CMD;{%s};02;Enable2\r", "uniqueId");
            }
            case "alarmDisarm": {
                return this.formatCommand(command, "SA200CMD;{%s};02;Disable2\r", "uniqueId");
            }
        }
        return null;
    }
}

